--
function healMercs()
	--
	local log_id = "hospital"
	if not(isValid(CUR_MISSION.Name)) then
		local time_minute = getVariable("time_minute")
		local hired_mercs = getHiredMercs(true)
		local doctors_roster = {}
		
		local function findDoctors(squad, patient)
			local doctor_skill = 0
			local doctor_num = 0
			
			local check = function(index, id)
				if (id ~= patient) then
					if (getMercSquad(id) == squad) then
						if (getAssignment(id) == "doctor_str") then
							local id_skill = getParameter(id, "MEDICAL") * getParameter(id, "HEALTH") / getParameter(id, "DURABILITYMAX")
							doctor_skill = doctor_skill + id_skill
							doctor_num = doctor_num + 1
							doctors_roster[squad] = id
						end
					end
				end
			end
			
			table.foreach(hired_mercs, check)

						
			if (doctor_num ~= 0) then
				return (doctor_skill/doctor_num)
			end

			return 0
		end

		local function teachDoctors(squad, patient)
		
			local teach = function(dsquad, doctor)
--				if (id ~= patient) then
					if (dsquad == squad) then
--						if (getAssignment(id) == "doctor_str") then
							onSignal(doctor, "HEALED_SOMEONE", patient)
--						end
					end
--				end
			end
			
			table.foreach(doctors_roster, teach)
		end
		
		local function calcTimeTo(patient, skill)
			HEAL_TIMETO[patient] = MIN_HEAL_TIME + (1 - (skill / 100)) * (60 - MIN_HEAL_TIME)
			log(log_id, patient, "TIME TO", HEAL_TIMETO[patient])
			if (HEAL_TIMETO[patient] > 60) then
				log(log_id, patient, "    -   60")
				HEAL_TIMETO[patient] = 60
			end
		end
		
		local squadHasPatients = {}

		local heal_hired = function(index, merc)
			local squad = getMercSquad(merc)
			log(log_id, merc, Mercs[merc].hired, Mercs[merc].alive, SQUAD_IS_MOVING["squad"..squad])
			if (SQUAD_IS_MOVING["squad"..squad] ~= true) then
				
				local passed_time 	= HEAL_PASSED[merc]
				local time_to 		= HEAL_TIMETO[merc]
				local health 		= getParameter(merc, "HEALTH")
				local max_health 	= getParameter(merc, "DURABILITYMAX")
				local skill 		= getParameter(merc, "MEDICAL")
				local effective_skill = skill * health / max_health
				local doctor_skill	= findDoctors(squad, merc)
				local assignment	= getAssignment(merc)

				log(log_id, "checking health of", squad, merc)
				
				if (health ~= max_health) then
				
					log(log_id, merc, "  ",health,"/",max_health)
					log(log_id, squad, merc, "base medical skill", skill)
					log(log_id, squad, merc, "effective medical skill", effective_skill)
				
					if (assignment == "patient_str") then
						squadHasPatients[squad] = true
						log(log_id, squad, merc, "is patient - medical skill doesn't apply, but bonus to doctors applies")
						skill = 1.5 * doctor_skill
					elseif (assignment == "doctor_str") then
						squadHasPatients[squad] = true
						log(log_id, squad, merc, "is doctor - medical skill fully applies")
						skill = effective_skill + doctor_skill
					else
						log(log_id, squad, merc, "medical skill halved")
						skill = effective_skill * 0.5 + doctor_skill
					end
					
					if (skill <= 0) then 
						skill = 1
					elseif (skill > 100) then
						skill = 100
					end
	
					log(log_id, squad, merc, "doctors average medical skill", doctor_skill)
					log(log_id, squad, merc, "overall medical skill", skill)
					
					if (passed_time == -1) then
						HEAL_PASSED[merc] = 0
						calcTimeTo(merc, skill)
						log(log_id, merc," ")
					else
						passed_time = passed_time + 1
						log(log_id, merc, "  -  ", passed_time)
						if (passed_time >= time_to) then
							log(log_id, merc, " ")
							health = health + 1
							setParameter(merc, "HEALTH", health)
							HEAL_PASSED[merc] = -1
							teachDoctors(squad, merc)
						else
							HEAL_PASSED[merc] = passed_time
							calcTimeTo(merc, skill)
						end
					end
				else
					log(log_id, merc," ")
					HEAL_PASSED[merc] = -1
				end
			end
		end
		
		local checkForHealed = function(index, merc)
		        local squad = getMercSquad(merc)
		        local needStop = false
		        if (SQUAD_IS_MOVING["squad"..squad] ~= true) then
		        	local assignment = getAssignment(merc)
				local health = getParameter(merc, "HEALTH")
				local max_health = getParameter(merc, "DURABILITYMAX")
				if(assignment == "patient_str") then
					if(health==max_health) then
						setPersonAssignment(merc,"rest_str")
						sendMessage("workdone_"..merc,NEW_MESSAGE)
						sound2D("ui/newbeep")
						needStop = true
					end
				elseif(assignment == "doctor_str") then
					if(not squadHasPatients[squad]) then
						setPersonAssignment(merc,"rest_str")
						sendMessage("workdone_"..merc,NEW_MESSAGE)
						sound2D("ui/newbeep")
						needStop = true
					end
				end
		        end
		        if(needStop) then
		        	stopTime()
		        end
		end

		if (TIME_CHECKER ~= time_minute) then
			log(log_id, "    ")
			TIME_CHECKER = time_minute
			table.foreach(hired_mercs, heal_hired)
			table.foreach(hired_mercs, checkForHealed)
		end
	end
	--
end
--